package ru.yandex.inside.goals.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown = true)
public class GoalLog {

    private final Goal oldGoal;
    private final Goal newGoal;
    private final String user;
    private final DateTime updated;

    @JsonCreator
    public GoalLog(@JsonProperty("old_value") Goal oldGoal,
                   @JsonProperty("new_value") Goal newGoal,
                   @JsonProperty("username") String user,
                   @JsonProperty("updated") DateTime updated) {
        this.oldGoal = oldGoal;
        this.newGoal = newGoal;
        this.user = user;
        this.updated = updated;
    }

    public Goal getOldGoal() {
        return oldGoal;
    }

    public Goal getNewGoal() {
        return newGoal;
    }

    public String getUser() {
        return user;
    }

    public DateTime getUpdated() {
        return updated;
    }
}
