package ru.yandex.inside.goals.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.http.client.ClientProtocolException;

/**
 * User reference. UID and Login fields comply to Staff ones.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoalUserRef {

    private final UserRef person;

    @JsonCreator
    public GoalUserRef(@JsonProperty("person") UserRef person) throws ClientProtocolException {

        this.person = person;
    }

    public UserRef getPerson() {
        return person;
    }
}
