package ru.yandex.inside.goals.model;

import java.util.List;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Response for list requests. Useful for loading page by page.
 */
public class ListResponse<T> {

    private final int count;
    private final Optional<String> next;
    private final Optional<String> previous;
    private final List<T> results;

    @JsonCreator
    public ListResponse(@JsonProperty("count") int count,
                        @JsonProperty("next") Optional<String> next,
                        @JsonProperty("previous") Optional<String> previous,
                        @JsonProperty("results") List<T> results) {
        this.count = count;
        this.next = next;
        this.previous = previous;
        this.results = results;
    }

    public int getCount() {
        return count;
    }

    public Optional<String> getNext() {
        return next;
    }

    public Optional<String> getPrevious() {
        return previous;
    }

    public List<T> getResults() {
        return results;
    }
}
