package ru.yandex.inside.goals.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * User reference. UID and Login comply to Staff ones.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class UserRef {

    private final long uid;
    private final String login;

    @JsonCreator
    public UserRef(@JsonProperty("uid") long uid,
                   @JsonProperty("login") String login) {
        this.uid = uid;
        this.login = login;
    }

    public long getUid() {
        return uid;
    }

    public String getLogin() {
        return login;
    }
}
