package ru.yandex.qe.hitman.tvm.qloud;

public class QloudTvmConfiguration {

    private final String applicationClientId;
    private final int applicationClientSelfId;
    private final String qloudToken;

    /**
     * @param applicationClientId     field "Name" in TVM secret configuration or raw TVM client id
     * @param applicationClientSelfId TVM client id (non-aliased)
     * @param qloudToken              value of the environment variable QLOUD_TVM_TOKEN
     */
    public QloudTvmConfiguration(final String applicationClientId,
                                 final int applicationClientSelfId,
                                 final String qloudToken) {
        this.applicationClientId = applicationClientId;
        this.applicationClientSelfId = applicationClientSelfId;
        this.qloudToken = qloudToken;
    }

    public String getApplicationClientId() {
        return applicationClientId;
    }

    public int getApplicationClientSelfId() {
        return applicationClientSelfId;
    }

    public String getQloudToken() {
        return qloudToken;
    }

    @Override
    public String toString() {
        return "QloudTvmConfiguration{" +
                "applicationClientId='" + applicationClientId + '\'' +
                ", applicationClientSelfId=" + applicationClientSelfId +
                '}';
    }
}
