package ru.yandex.qe.hitman.tvm.qloud;

import java.util.Optional;
import java.util.Set;

public class QloudTvmServiceStub implements QloudTvmService {

    public Set<String> allowedTargetClientIds;

    public QloudTvmServiceStub(final Set<String> allowedTargetClientIds) {
        this.allowedTargetClientIds = allowedTargetClientIds;
    }

    @Override
    public String getTicket(final String targetClientId) {
        if (allowedTargetClientIds.contains(targetClientId)) {
            return "FAKE-SERVICE-TICKET";
        } else {
            throw new IllegalArgumentException(
                    "Attempting to request ticket for disallowed destination " + targetClientId);
        }
    }

    @Override
    public boolean isValidTarget(final String clientId) {
        return allowedTargetClientIds.contains(clientId);
    }

    @Override
    public Optional<TvmServiceTicketInfo> validateServiceTicket(final String serviceTicket) {
        return Optional.empty();
    }

    @Override
    public Optional<TvmUserTicketInfo> validateUserTicket(final String userTicket) {
        return Optional.empty();
    }

}
