package ru.yandex.qe.hitman.tvm.qloud;

import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TvmDaemonConfiguration {

    private final BlackboxEnvironmentType environmentType;
    private final Integer port;
    private final Map<String, Client> clients;

    @JsonCreator
    public TvmDaemonConfiguration(@JsonProperty("BbEnvType") final BlackboxEnvironmentType environmentType,
                                  @JsonProperty("port") final Integer port,
                                  @JsonProperty("clients") final Map<String, Client> clients) {
        this.environmentType = environmentType;
        this.port = port;
        this.clients = clients;
    }

    @JsonProperty("BbEnvType")
    public BlackboxEnvironmentType getEnvironmentType() {
        return environmentType;
    }

    @JsonProperty("port")
    public Integer getPort() {
        return port;
    }

    @JsonProperty("clients")
    public Map<String, Client> getClients() {
        return clients;
    }

    @Override
    public String toString() {
        return "TvmConfiguration{" +
                "environmentType=" + environmentType +
                ", port=" + port +
                ", clients=" + clients +
                '}';
    }

    public enum BlackboxEnvironmentType {

        PROD(0),
        TEST(1),
        PROD_YA_TEAM(2),
        TEST_YA_TEAM(3),
        STRESS(4);

        private final int index;

        BlackboxEnvironmentType(final int index) {
            this.index = index;
        }

        @JsonValue
        public int getIndex() {
            return index;
        }
    }

    public static class Client {

        private final String secret;
        private final int id;
        private final Map<String, Destination> destinations;

        @JsonCreator
        public Client(@JsonProperty("secret") final String secret,
                      @JsonProperty("self_tvm_id") final int id,
                      @JsonProperty("dsts") final Map<String, Destination> destinations) {
            this.secret = secret;
            this.id = id;
            this.destinations = destinations;
        }

        @JsonProperty("secrets")
        public String getSecret() {
            return secret;
        }

        @JsonProperty("self_tvm_id")
        public int getId() {
            return id;
        }

        @JsonProperty("dsts")
        public Map<String, Destination> getDestinations() {
            return destinations;
        }

        @Override
        public String toString() {
            return "Client{" +
                    "id=" + id +
                    ", destinations=" + destinations +
                    '}';
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final Client client = (Client) o;
            return id == client.id;
        }

        @Override
        public int hashCode() {
            return Objects.hash(id);
        }
    }

    public static class Destination {

        private final int id;

        @JsonCreator
        public Destination(@JsonProperty("dst_id") final int id) {
            this.id = id;
        }

        @JsonProperty("dst_id")
        public int getId() {
            return id;
        }

        @Override
        public String toString() {
            return "Destination{" +
                    "id=" + id +
                    '}';
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final Destination that = (Destination) o;
            return id == that.id;
        }

        @Override
        public int hashCode() {
            return Objects.hash(id);
        }
    }

}
