package ru.yandex.qe.hitman.tvm.qloud;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TvmServiceTicketInfo {

    private final int source;
    private final int destination;
    private final List<String> scopes;

    private final String debugString;
    private final String loggingString;

    @JsonCreator
    public TvmServiceTicketInfo(@JsonProperty("src") final int source,
                                @JsonProperty("dst") final int destination,
                                @JsonProperty("scopes") final List<String> scopes,
                                @JsonProperty("debug_string") final String debugString,
                                @JsonProperty("logging_string") final String loggingString) {
        this.source = source;
        this.destination = destination;
        this.scopes = scopes;
        this.debugString = debugString;
        this.loggingString = loggingString;
    }

    @JsonProperty("src")
    public int getSource() {
        return source;
    }

    @JsonProperty("dst")
    public int getDestination() {
        return destination;
    }

    public List<String> getScopes() {
        return scopes;
    }

    @JsonProperty("debug_string")
    public String getDebugString() {
        return debugString;
    }

    @JsonProperty("logging_string")
    public String getLoggingString() {
        return loggingString;
    }

    @Override
    public String toString() {
        return "{" + debugString + ";contents=" + loggingString + "...}";
    }

}
