package ru.yandex.qe.hitman.tvm.qloud;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TvmUserTicketInfo {

    private final String defaultUid;
    private final List<String> uids;
    private final List<String> scopes;

    private final String debugString;
    private final String loggingString;

    @JsonCreator
    public TvmUserTicketInfo(@JsonProperty("default_uid") final String defaultUid,
                             @JsonProperty("uids") final List<String> uids,
                             @JsonProperty("scopes") final List<String> scopes,
                             @JsonProperty("debug_string") final String debugString,
                             @JsonProperty("logging_string") final String loggingString) {
        this.defaultUid = defaultUid;
        this.uids = uids;
        this.scopes = scopes;
        this.debugString = debugString;
        this.loggingString = loggingString;
    }

    @JsonProperty("default_uid")
    public String getDefaultUid() {
        return defaultUid;
    }

    @JsonProperty("uids")
    public List<String> getUids() {
        return uids;
    }

    @JsonProperty("scopes")
    public List<String> getScopes() {
        return scopes;
    }

    @JsonProperty("debug_string")
    public String getDebugString() {
        return debugString;
    }

    @JsonProperty("logging_string")
    public String getLoggingString() {
        return loggingString;
    }

    @Override
    public String toString() {
        return "{" + debugString + ";contents=" + loggingString + "...}";
    }

}
