package ru.yandex.qe.hitman.tvm.v1;

import java.io.IOException;
import java.time.Instant;

import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by akhvorov on 23.08.17.
 */
public class TVM1TicketServiceImpl extends AbstractTVM1TicketService {

    private static final Logger LOG = LoggerFactory.getLogger(TVM1TicketServiceImpl.class);

    private static final HttpClientBuilder httpClientBuilder = HttpClientBuilder.create()
            .setDefaultRequestConfig(
                    RequestConfig.custom()
                            .setConnectTimeout(1_000)
                            .setSocketTimeout(60_0000)
                            .build()
            );

    public <T extends HttpRequest> T addTicketHeader(final T request, final String headerName, final String clientId,
                                                     final String secret) {
        final String timestamp = Long.toString(Instant.now().toEpochMilli() / 1000);
        final String tsSign = tsSign(secret, timestamp);
        request.addHeader(headerName, ticket(clientId, tsSign, timestamp));
        return request;
    }

    private String ticket(final String clientId, final String tsSign, final String timestamp) {
        try {
            final HttpUriRequest request = buildRequest(clientId, tsSign, timestamp);
            LOG.debug("Requesting to TVM: {}", request.getURI().toString());
            final long startMs = System.currentTimeMillis();
            final HttpResponse response = httpClientBuilder.build().execute(request);
            LOG.info("Get ticket from TVM in {}ms", System.currentTimeMillis() - startMs);
            return parseResponse(response);
        } catch (IOException e) {
            throw new RuntimeException("can't execute request", e);
        }
    }
}
