import sys
import urllib2
import json


def load_aggregates(lunapark_id):
    return json.loads(urllib2.urlopen('https://lunapark.yandex-team.ru/api/job/%s/aggregates.json' % lunapark_id).read())[0]


def get_http_200_percent(aggregates):
    return aggregates["http_200_percent"]


def get_q95(aggregates):
    return aggregates["q95"]


HTTP_200_PERCENT_LIMIT = 90
Q95_DIFF_LIMIT = 100


def main():
    prev_lunapark_id = sys.argv[1]
    lunapark_id = sys.argv[2]
    prev_aggregates = load_aggregates(prev_lunapark_id)
    aggregates = load_aggregates(lunapark_id)

    http_200_percent = get_http_200_percent(aggregates)
    if http_200_percent < HTTP_200_PERCENT_LIMIT:
        raise RuntimeError("http 200 %d%% < %d%%" % (http_200_percent, HTTP_200_PERCENT_LIMIT))

    prev_q95 = get_q95(prev_aggregates)
    q95 = get_q95(aggregates)

    if q95 - prev_q95 > Q95_DIFF_LIMIT:
        raise RuntimeError("q95 - previous q95 = %d > %d" % (q95 - prev_q95, Q95_DIFF_LIMIT))


if __name__ == '__main__':
    main()
