#!/usr/bin/env bash

set -x

TEAMCITY_BUILD_CONFIGURATION_ID=dispenser_service_LoadTest

OPERATOR=zomb-mobsearch
AMMO_FILE=https://storage-int.mds.yandex.net/get-load-ammo/23470/6202b5d08b50fe93738c5bb5f5d48576
RPS_SCHEDULE='line(0, 150, 3m)'
DISPENSER_HOST=sas1-77c05e9badda.qloud-c.yandex.net
TANK_HOST=sas1-dc9612464dc0.qloud-c.yandex.net
SERVER_VERSION=$(curl http://${DISPENSER_HOST}/api/version | python -c "import sys, json; print json.load(sys.stdin)['serverVersion']")

# Reinitialize environment
echo "##teamcity[progressMessage 'Reinitializing load-testing environment']"
REINITIALIZATION_STATUS=$(curl "http://$DISPENSER_HOST/api/admin/reinitialize?nocache=true")
if [ "$REINITIALIZATION_STATUS" != "OK" ]
then
  echo "##teamcity[buildStatus status='FAILURE' text='Reinitialization failed']"
  exit 1
fi

# Start load testing task
echo "##teamcity[progressMessage 'Starting Lunapark task']"
curl -X POST "https://lunapark.yandex-team.ru/firestarter/fire" -d "conf=%0A%5Bphantom%5D%0Aammofile%3D$AMMO_FILE%0Aheader_http%3D1.0%0Arps_schedule%3D$RPS_SCHEDULE%0Auris%3D%0Aaddress%3D$DISPENSER_HOST%0A%5Bmeta%5D%0Atask%3DDISPENSER-100%0Ause_tank%3D$TANK_HOST%0Ajobno_file%3D%2Fvar%2Flib%2Ftankapi%2Ftests%2Fjobno_file.txt%0Alock_targets%3Dpgload02g.mail.yandex.net+pgload02e.mail.yandex.net+pgload02d.mail.yandex.net%0Aoperator%3D$OPERATOR%0Ajob_name%3D$SERVER_VERSION%0A%5Bmonitoring%5D%0Aconfig_contents%3D%3CMonitoring%3E%0A%09%3CHost+address%3D%22%5Btarget%5D%22+%2F%3E%0A%09%3C%2FMonitoring%3E%0Adefault_target%3Dlocalhost%0Aconfig%3Dauto%0Assh_timeout%3D5s%0A" -H "Authorization: OAuth $TOKEN" > firestarter.json
SUCCESS=$(cat firestarter.json | python -c "import sys, json; print json.load(sys.stdin)['success']")
if [ "$SUCCESS" != "True" ]
then
  echo "##teamcity[buildStatus status='FAILURE' text='Failed to start Lunapark task']"
  exit 1
fi

# Get Lunapark task url and id
ID=$(cat firestarter.json | python -c "import sys, json; print json.load(sys.stdin)['id']")
while true
do
  curl "http://$TANK_HOST:8083/api/v1/tests/$ID/status.json" > tank.json
  LUNAPARK_ID=$(cat tank.json | python -c "import sys, json; print json.load(sys.stdin)['lunapark_id']")
  LUNAPARK_URL=$(cat tank.json | python -c "import sys, json; print json.load(sys.stdin)['lunapark_url']")
  if [ -n "$LUNAPARK_ID" ] && [ "$LUNAPARK_ID" != "None" ]
  then
    break
  fi
  sleep 10
done

# Create report
PREV_LUNAPARK_ID=$(curl "http://teamcity.yandex.ru/httpAuth/repository/download/$TEAMCITY_BUILD_CONFIGURATION_ID/.lastSuccessful/tank.json" -u teamcity:Cleph8OvOwd | python -c "import sys, json; print json.load(sys.stdin)['lunapark_id']")

echo "<meta charset='utf-8'>" > lunapark.html
echo "<a href=${LUNAPARK_URL} target='_blank'>Ссылка на стрельбу</a><br>" >> lunapark.html
echo "<a href='https://lunapark.yandex-team.ru/compare/#jobs=$PREV_LUNAPARK_ID,$LUNAPARK_ID&helper=all&mainjob=$LUNAPARK_ID' target='_blank'>Сравнить с предыдущей</a>" >> lunapark.html

# Wait for Lunapark task to finish
echo "##teamcity[progressMessage 'Waiting for Lunapark task to finish']"
while true
do
  STATUS_CODE=$(curl "http://$TANK_HOST:8083/api/v1/tests/$ID/status.json" | python -c "import sys, json; print json.load(sys.stdin)['status_code']")
  if [ "$STATUS_CODE" = "FINISHED" ]
  then
    break
  fi
  sleep 30
done

# Compare to previous
echo "##teamcity[progressMessage 'Comparing results to previous test']"
#curl "https://git.qe-infra.yandex-team.ru/projects/DISPENSER/repos/dispenser-service/browse/scripts/lunapark/compare.py?raw" > compare.py
python ./scripts/lunapark/compare.py ${PREV_LUNAPARK_ID} ${LUNAPARK_ID}

echo "##teamcity[buildStatus text='Load tested $SERVER_VERSION']"
