import logging
import re

from tickets_collector import call_subprocess, write_tickets, FIND_TICKETS_EXPRESSION, PARENT_MODULE_PATH

logging.basicConfig(format='%(asctime)s [%(levelname)s] %(message)s', level=logging.DEBUG)


def main():
    logging.info('Start collecting tickets for release')
    gitlog = create_gitlog()
    tickets = collect_tickets_from_gitlog(gitlog)
    logging.info('FInish collecting tickets = %s' % str(tickets))
    logging.info('Writing tickets to file')
    write_tickets(tickets)
    logging.info('Finish collecting tickets for release')


def create_gitlog():
    logging.info('Fetch origin/master')
    call_subprocess(PARENT_MODULE_PATH, 'git', 'fetch', 'origin', 'master')

    logging.info('Creating gitlog from origin/master to develop branch')
    return call_subprocess(PARENT_MODULE_PATH, 'git', 'log', 'origin/master..')


def collect_tickets_from_gitlog(gitlog):
    logging.info('Collecting tickets from gitlog')
    tickets = (set(re.findall(FIND_TICKETS_EXPRESSION, gitlog)))
    return tickets


if __name__ == "__main__":
    main()
