package ru.yandex.qe.dispenser.application.startup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.hierarchy.Role;

public class LoadTestingInitialState extends DevelopmentInitialState {
    private static final Logger LOG = LoggerFactory.getLogger(LoadTestingInitialState.class);

    private static final int PROJECTS_COUNT = 100;
    private static final int USERS_COUNT = 20;

    @Override
    public void configure() {
        LOG.debug("Started initialization");
        super.configure();
        generateProjectsAndUsers();
        LOG.debug("Finished initialization");
    }

    private void generateProjectsAndUsers() {
        final Project yandex = projectDao.read("yandex");
        // projects
        final List<Project> projects = IntStream.rangeClosed(1, PROJECTS_COUNT)
                .mapToObj(id -> "project-" + id)
                .map(key -> Project.withKey(key).name(StringUtils.capitalize(key).replace("-", " ")).parent(yandex).build())
                .collect(Collectors.toList());
        final Collection<Project> createdProjects = projectDao.createAllIfAbsent(projects).values();
        // users
        final List<String> logins = IntStream.rangeClosed(1, USERS_COUNT)
                .mapToObj(id -> "user-" + id)
                .collect(Collectors.toList());
        final Collection<Person> persons = personDao.readPersonsByLogins(logins);
        projectDao.attachAll(persons, Collections.emptyList(), yandex, Role.MEMBER);
        // personal projects
        final List<Project> personalProjects = new ArrayList<>();
        for (final Project project : createdProjects) {
            for (final Person person : persons) {
                personalProjects.add(Project.withKey(Project.Key.of(project.getPublicKey(), person))
                        .name(project.getName())
                        .parent(project)
                        .build());
            }
        }
        projectDao.createAllIfAbsent(personalProjects);
    }
}
