package ru.yandex.qe.dispenser.domain;

import java.util.Set;

import org.jetbrains.annotations.Nullable;

public class BotCampaignGroupUpdate {
    @Nullable
    private final String key;
    @Nullable
    private final String name;
    @Nullable
    private final Boolean active;
    @Nullable
    private final Set<Long> bigOrders;
    @Nullable
    private final String botPreOrderIssueKey;
    @Nullable
    private final Set<Long> campaigns;

    public BotCampaignGroupUpdate(@Nullable final String key,
                                  @Nullable final String name,
                                  @Nullable final Boolean active,
                                  @Nullable final Set<Long> bigOrders,
                                  @Nullable final String botPreOrderIssueKey,
                                  @Nullable final Set<Long> campaigns) {
        this.key = key;
        this.name = name;
        this.active = active;
        this.bigOrders = bigOrders;
        this.botPreOrderIssueKey = botPreOrderIssueKey;
        this.campaigns = campaigns;
    }

    @Nullable
    public String getKey() {
        return key;
    }

    @Nullable
    public String getName() {
        return name;
    }

    @Nullable
    public Boolean getActive() {
        return active;
    }

    @Nullable
    public Set<Long> getBigOrders() {
        return bigOrders;
    }

    @Nullable
    public String getBotPreOrderIssueKey() {
        return botPreOrderIssueKey;
    }

    @Nullable
    public Set<Long> getCampaigns() {
        return campaigns;
    }

    public boolean hasSimpleFieldsUpdate() {
        return key != null || name != null || botPreOrderIssueKey != null || active != null;
    }

    public boolean hasBigOrdersUpdate() {
        return bigOrders != null;
    }

    public boolean hasCampaignsUpdate() {
        return campaigns != null;
    }

    public boolean hasActivenessUpdate() {
        return active != null;
    }

    public boolean hasUpdates() {
        return hasSimpleFieldsUpdate() || hasBigOrdersUpdate() || hasCampaignsUpdate();
    }
}
