package ru.yandex.qe.dispenser.domain;

import java.math.BigInteger;
import java.util.Objects;

import org.jetbrains.annotations.NotNull;

/**
 * Owning cost of all quota requests from campaign.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class CampaignOwningCost {
    private final long campaignId;
    @NotNull
    private final BigInteger owningCost;

    private CampaignOwningCost(long campaignId, @NotNull BigInteger owningCost) {
        this.campaignId = campaignId;
        this.owningCost = owningCost;
    }

    public long getCampaignId() {
        return campaignId;
    }

    @NotNull
    public BigInteger getOwningCost() {
        return owningCost;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignOwningCost that = (CampaignOwningCost) o;
        return campaignId == that.campaignId && Objects.equals(owningCost, that.owningCost);
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId, owningCost);
    }

    @Override
    public String toString() {
        return "CampaignOwningCost{" +
                "campaignId=" + campaignId +
                ", owningCost=" + owningCost +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return builder()
                .campaignId(campaignId)
                .owningCost(owningCost);
    }

    public static class Builder {
        private Long campaignId;
        private BigInteger owningCost;

        public Builder campaignId(Long campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder owningCost(BigInteger owningCost) {
            this.owningCost = owningCost;
            return this;
        }

        public CampaignOwningCost build() {
            return new CampaignOwningCost(
                    Objects.requireNonNull(campaignId),
                    Objects.requireNonNull(owningCost)
            );
        }
    }
}
