package ru.yandex.qe.dispenser.domain;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.Keyable;
import ru.yandex.qe.dispenser.domain.dictionaries.model.CampaignProvidersSettingsDictionary;

@ParametersAreNonnullByDefault
public class CampaignServiceResourcesPreset implements Keyable<CampaignServiceResourcesPreset.Key> {
    @NotNull
    private final Key key;
    @NotNull
    private final List<CampaignProvidersSettingsDictionary.ResourcePreset> resourcePresets;

    public CampaignServiceResourcesPreset(final Key key,
                                          final List<CampaignProvidersSettingsDictionary.ResourcePreset> resourcePresets) {
        this.key = key;
        this.resourcePresets = resourcePresets;
    }

    public long getCampaignId() {
        return key.campaignId;
    }

    public long getServiceId() {
        return key.serviceId;
    }

    @NotNull
    public List<CampaignProvidersSettingsDictionary.ResourcePreset> getResourcePresets() {
        return resourcePresets;
    }

    @NotNull
    @Override
    public Key getKey() {
        return key;
    }

    public static class Key implements Comparable<Key>, Serializable {
        private final long campaignId;
        private final long serviceId;

        public Key(final long campaignId, final long serviceId) {
            this.campaignId = campaignId;
            this.serviceId = serviceId;
        }

        public long getCampaignId() {
            return campaignId;
        }

        public long getServiceId() {
            return serviceId;
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final Key key = (Key) o;
            return campaignId == key.campaignId &&
                    serviceId == key.serviceId;
        }

        @Override
        public int hashCode() {
            return Objects.hash(campaignId, serviceId);
        }

        @Override
        public int compareTo(@NotNull final CampaignServiceResourcesPreset.Key o) {
            return Long.compare(campaignId, o.campaignId);
        }
    }
}
