package ru.yandex.qe.dispenser.domain;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.DtoBuilder;

public class CampaignUpdate {

    @Nullable
    private final String name;
    @Nullable
    private final Campaign.Status status;
    @Nullable
    private final LocalDate startDate;
    @Nullable
    private final List<Campaign.BigOrder> bigOrders;
    @Nullable
    private final Boolean requestCreationDisabled;
    @Nullable
    @Deprecated
    private final Boolean requestModificationDisabledForNonManagers;
    @Nullable
    private final Boolean allowedRequestModificationWhenClosed;
    @Nullable
    private final Boolean allowedModificationOnMissingAdditionalFields;
    @Nullable
    @Deprecated
    private final Boolean forcedAllowingRequestStatusChange;
    @Nullable
    private final Boolean singleProviderRequestModeEnabled;
    @Nullable
    @Deprecated
    private final Boolean allowedRequestCreationForProviderAdmin;
    @Nullable
    @Deprecated
    private final Boolean allowedRequestCreationForCapacityPlanner;
    @Nullable
    private final Boolean requestModificationDisabled;

    public static Builder builder() {
        return new Builder();
    }

    public CampaignUpdate(final Builder builder) {
        name = builder.name;
        status = builder.status;
        startDate = builder.startDate;
        bigOrders = builder.bigOrders;
        requestCreationDisabled = builder.requestCreationDisabled;
        requestModificationDisabledForNonManagers = builder.requestModificationDisabledForNonManagers;
        allowedRequestModificationWhenClosed = builder.allowedRequestModificationWhenClosed;
        allowedModificationOnMissingAdditionalFields = builder.allowedModificationOnMissingAdditionalFields;
        forcedAllowingRequestStatusChange = builder.forcedAllowingRequestStatusChange;
        singleProviderRequestModeEnabled = builder.singleProviderRequestModeEnabled;
        allowedRequestCreationForProviderAdmin = builder.allowedRequestCreationForProviderAdmin;
        allowedRequestCreationForCapacityPlanner = builder.allowedRequestCreationForCapacityPlanner;
        requestModificationDisabled = builder.requestModificationDisabled;
    }

    @Nullable
    public String getName() {
        return name;
    }

    @Nullable
    public Campaign.Status getStatus() {
        return status;
    }

    @Nullable
    public LocalDate getStartDate() {
        return startDate;
    }

    @Nullable
    public List<Campaign.BigOrder> getBigOrders() {
        return bigOrders;
    }

    @Nullable
    public Boolean getRequestCreationDisabled() {
        return requestCreationDisabled;
    }

    @Nullable
    @Deprecated
    public Boolean getRequestModificationDisabledForNonManagers() {
        return requestModificationDisabledForNonManagers;
    }

    @Nullable
    public Boolean getAllowedRequestModificationWhenClosed() {
        return allowedRequestModificationWhenClosed;
    }

    @Nullable
    public Boolean getAllowedModificationOnMissingAdditionalFields() {
        return allowedModificationOnMissingAdditionalFields;
    }

    @Nullable
    @Deprecated
    public Boolean getForcedAllowingRequestStatusChange() {
        return forcedAllowingRequestStatusChange;
    }

    @Nullable
    public Boolean getSingleProviderRequestModeEnabled() {
        return singleProviderRequestModeEnabled;
    }

    @Nullable
    @Deprecated
    public Boolean getAllowedRequestCreationForProviderAdmin() {
        return allowedRequestCreationForProviderAdmin;
    }

    @Nullable
    @Deprecated
    public Boolean getAllowedRequestCreationForCapacityPlanner() {
        return allowedRequestCreationForCapacityPlanner;
    }

    @Nullable
    public Boolean getRequestModificationDisabled() {
        return requestModificationDisabled;
    }

    public boolean hasSimpleFieldUpdates() {
        return name != null || status != null || startDate != null || requestCreationDisabled != null
                || requestModificationDisabledForNonManagers != null
                || allowedRequestModificationWhenClosed != null || allowedModificationOnMissingAdditionalFields != null
                || forcedAllowingRequestStatusChange != null || singleProviderRequestModeEnabled != null
                || allowedRequestCreationForProviderAdmin != null || allowedRequestCreationForCapacityPlanner != null
                || requestModificationDisabled != null;
    }

    @NotNull
    public Campaign apply(@NotNull final Campaign campaign) {
        final Campaign.Builder builder = campaign.copyBuilder();

        if (name != null) {
            builder.setName(name);
        }
        if (status != null) {
            builder.setStatus(status);
        }
        if (startDate != null) {
            builder.setStartDate(startDate);
        }
        if (bigOrders != null) {
            builder.setBigOrders(new ArrayList<>(bigOrders));
        }
        if (requestCreationDisabled != null) {
            builder.setRequestCreationDisabled(requestCreationDisabled);
        }
        if (requestModificationDisabledForNonManagers != null) {
            builder.setRequestModificationDisabledForNonManagers(requestModificationDisabledForNonManagers);
        }
        if (allowedRequestModificationWhenClosed != null) {
            builder.setAllowedRequestModificationWhenClosed(allowedRequestModificationWhenClosed);
        }
        if (allowedModificationOnMissingAdditionalFields != null) {
            builder.setAllowedRequestModificationWhenClosed(allowedModificationOnMissingAdditionalFields);
        }
        if (forcedAllowingRequestStatusChange != null) {
            builder.setForcedAllowingRequestStatusChange(forcedAllowingRequestStatusChange);
        }
        if (singleProviderRequestModeEnabled != null) {
            builder.setSingleProviderRequestModeEnabled(singleProviderRequestModeEnabled);
        }
        if (allowedRequestCreationForProviderAdmin != null) {
            builder.setAllowedRequestCreationForProviderAdmin(allowedRequestCreationForProviderAdmin);
        }
        if (allowedRequestCreationForCapacityPlanner != null) {
            builder.setAllowedRequestCreationForCapacityPlanner(allowedRequestCreationForCapacityPlanner);
        }
        if (requestModificationDisabled != null) {
            builder.setRequestModificationDisabled(requestModificationDisabled);
        }

        return builder.build();
    }

    protected static class BuilderBase<B extends BuilderBase<B>> {
        @Nullable
        protected String name;
        @Nullable
        protected Campaign.Status status;
        @Nullable
        protected List<Campaign.BigOrder> bigOrders;
        @Nullable
        protected LocalDate startDate;
        @Nullable
        protected Boolean requestCreationDisabled;
        @Nullable
        @Deprecated
        protected Boolean requestModificationDisabledForNonManagers;
        @Nullable
        protected Boolean allowedRequestModificationWhenClosed;
        @Nullable
        protected Boolean allowedModificationOnMissingAdditionalFields;
        @Nullable
        @Deprecated
        protected Boolean forcedAllowingRequestStatusChange;
        @Nullable
        protected Boolean singleProviderRequestModeEnabled;
        @Nullable
        @Deprecated
        protected Boolean allowedRequestCreationForProviderAdmin;
        @Nullable
        @Deprecated
        protected Boolean allowedRequestCreationForCapacityPlanner;
        @Nullable
        protected Boolean requestModificationDisabled;

        public B setName(final String name) {
            this.name = name;
            return self();
        }

        public B setStatus(final Campaign.Status status) {
            this.status = status;
            return self();
        }

        public B setBigOrders(final List<Campaign.BigOrder> bigOrders) {
            this.bigOrders = bigOrders;
            return self();
        }

        public B setStartDate(final LocalDate startDate) {
            this.startDate = startDate;
            return self();
        }

        public B setRequestCreationDisabled(final Boolean requestCreationDisabled) {
            this.requestCreationDisabled = requestCreationDisabled;
            return self();
        }

        @Deprecated
        public B setRequestModificationDisabledForNonManagers(final Boolean requestModificationDisabledForNonManagers) {
            this.requestModificationDisabledForNonManagers = requestModificationDisabledForNonManagers;
            return self();
        }

        public B setAllowedRequestModificationWhenClosed(final Boolean allowedRequestModificationWhenClosed) {
            this.allowedRequestModificationWhenClosed = allowedRequestModificationWhenClosed;
            return self();
        }

        public B setAllowedModificationOnMissingAdditionalFields(final Boolean allowedModificationOnMissingAdditionalFields) {
            this.allowedModificationOnMissingAdditionalFields = allowedModificationOnMissingAdditionalFields;
            return self();
        }

        @Deprecated
        public B setForcedAllowingRequestStatusChange(final Boolean forcedAllowingRequestStatusChange) {
            this.forcedAllowingRequestStatusChange = forcedAllowingRequestStatusChange;
            return self();
        }

        public B setSingleProviderRequestModeEnabled(final Boolean singleProviderRequestModeEnabled) {
            this.singleProviderRequestModeEnabled = singleProviderRequestModeEnabled;
            return self();
        }

        @Deprecated
        public B setAllowedRequestCreationForProviderAdmin(final Boolean allowedRequestCreationForProviderAdmin) {
            this.allowedRequestCreationForProviderAdmin = allowedRequestCreationForProviderAdmin;
            return self();
        }

        @Deprecated
        public B setAllowedRequestCreationForCapacityPlanner(final Boolean allowedRequestCreationForCapacityPlanner) {
            this.allowedRequestCreationForCapacityPlanner = allowedRequestCreationForCapacityPlanner;
            return self();
        }

        public B setRequestModificationDisabled(final Boolean requestModificationDisabled) {
            this.requestModificationDisabled = requestModificationDisabled;
            return self();
        }

        @SuppressWarnings("unchecked")
        protected B self() {
            return (B) this;
        }
    }

    public static class Builder extends BuilderBase<Builder> implements DtoBuilder<CampaignUpdate> {

        @Override
        @NotNull
        public CampaignUpdate build() {
            return new CampaignUpdate(this);
        }
    }

}
