package ru.yandex.qe.dispenser.domain;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.DtoBuilder;
import ru.yandex.qe.dispenser.api.v1.DiDispenserSettings;
import ru.yandex.qe.dispenser.domain.dao.dispenser_admins.DispenserAdminsReader;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;
import ru.yandex.qe.dispenser.domain.util.CollectionUtils;

public class DispenserSettings {
    private DispenserSettings() {
    }


    public static Builder build() {
        return new Builder();
    }

    @NotNull
    public DiDispenserSettings toView() {
        return toView(Hierarchy.get().getDispenserAdminsReader());
    }

    @NotNull
    public DiDispenserSettings toView(@NotNull final DispenserAdminsReader dispenserAdminsReader) {
        return DiDispenserSettings.builder()
                .withAdmins(CollectionUtils.map(dispenserAdminsReader.getDispenserAdmins(), Person::getLogin))
                .build();
    }


    public static final class Builder implements DtoBuilder<DispenserSettings> {

        private Builder() {

        }

        @NotNull
        @Override
        public DispenserSettings build() {
            return new DispenserSettings();
        }
    }


}
