package ru.yandex.qe.dispenser.domain;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.index.NormalizedPrimaryKeyBase;

@Deprecated
public final class EntityMetaType<T> extends NormalizedPrimaryKeyBase<EntityMetaType.Key> {
    @NotNull
    private final Class<T> dataType;

    public EntityMetaType(@NotNull final String key, @NotNull final Class<T> dataType, @NotNull final EntitySpec spec) {
        super(new Key(key, spec));
        this.dataType = dataType;
    }

    @NotNull
    public EntitySpec getSpec() {
        return getKey().getSpec();
    }

    @NotNull
    public Class<T> getDataType() {
        return dataType;
    }

    public static final class Key implements Comparable<Key> {
        @NotNull
        private final String key;
        @NotNull
        private final EntitySpec spec;

        public Key(@NotNull final String key, @NotNull final EntitySpec spec) {
            this.key = key;
            this.spec = spec;
        }

        @NotNull
        public String getPublicKey() {
            return key;
        }

        @NotNull
        public EntitySpec getSpec() {
            return spec;
        }

        @Override
        public int compareTo(@NotNull final Key key) {
            return new CompareToBuilder().append(key, key.key).append(spec, key.spec).build();
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            return key.equals(((Key) o).key) && spec.equals(((Key) o).spec);

        }

        @Override
        public int hashCode() {
            return 31 * key.hashCode() + spec.hashCode();
        }
    }
}
