package ru.yandex.qe.dispenser.domain;

import java.time.Instant;
import java.util.Objects;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.domain.index.LongIndexBase;

public abstract class HistoryEvent extends LongIndexBase {
    private final Long personId;
    private final Long tvmId;
    private final Instant updated;
    private final String comment;

    protected HistoryEvent(@Nullable final Long personId,
                           @Nullable final Long tvmId,
                           @NotNull final Instant updated,
                           @Nullable final String comment) {
        this.comment = comment;
        if (personId == null && tvmId == null) {
            throw new IllegalArgumentException("personId or tvmId is required!");
        }
        this.personId = personId;
        this.tvmId = tvmId;
        this.updated = updated;
    }

    @Nullable
    public Long getPersonId() {
        return personId;
    }

    @Nullable
    public Long getTvmId() {
        return tvmId;
    }

    @NotNull
    public Instant getUpdated() {
        return updated;
    }

    @Nullable
    public String getComment() {
        return comment;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final HistoryEvent that = (HistoryEvent) o;
        return Objects.equals(getPersonId(), that.getPersonId()) &&
                Objects.equals(getTvmId(), that.getTvmId()) &&
                Objects.equals(getUpdated(), that.getUpdated()) &&
                Objects.equals(getComment(), that.getComment()) &&
                Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getPersonId(), getTvmId(), getUpdated(), getComment());
    }
}
