package ru.yandex.qe.dispenser.domain;

import java.util.Locale;

import javax.inject.Inject;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class MessageHelper {

    private final MessageSource messageSource;

    @Inject
    public MessageHelper(@Qualifier("messageSource") final MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String format(final String key, final Object... args) {
        return messageSource.getMessage(key, args, Locale.getDefault());
    }

}
