package ru.yandex.qe.dispenser.domain;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.index.NormalizedPrimaryKeyBase;

/**
 * Логин пользователя.
 */
public final class Person extends NormalizedPrimaryKeyBase<String> {

    private final long uid;
    private final boolean robot;
    private final boolean dismissed;
    private final boolean deleted;
    @NotNull
    private final PersonAffiliation affiliation;

    public Person(@NotNull final String login, final long uid, final boolean robot, final boolean dismissed,
                  final boolean deleted, @NotNull final PersonAffiliation affiliation) {
        super(login);
        this.uid = uid;
        this.robot = robot;
        this.dismissed = dismissed;
        this.deleted = deleted;
        this.affiliation = affiliation;
    }

    public Person(final long id, @NotNull final String login, final long uid, final boolean robot, final boolean dismissed,
                  final boolean deleted, @NotNull final PersonAffiliation affiliation) {
        this(login, uid, robot, dismissed, deleted, affiliation);
        setId(id);
    }

    @NotNull
    public String getLogin() {
        return getKey();
    }

    public long getUid() {
        return uid;
    }

    public boolean isRobot() {
        return robot;
    }

    public boolean isDismissed() {
        return dismissed;
    }

    public boolean isDeleted() {
        return deleted;
    }

    @NotNull
    public PersonAffiliation getAffiliation() {
        return affiliation;
    }

    public String getMail() {
        return getLogin() + "@yandex-team.ru";
    }

    @NotNull
    @Override
    public String toString() {
        return getLogin();
    }
}
