package ru.yandex.qe.dispenser.domain;

import java.util.Objects;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.index.NormalizedPrimaryKeyBase;

public class PersonGroupMembership extends NormalizedPrimaryKeyBase<PersonGroupMembership.Key> {

    public PersonGroupMembership(@NotNull final Person person, @NotNull final YaGroup group, @NotNull final PersonGroupMembershipType membershipType) {
        super(new Key(person, group, membershipType));
    }

    @NotNull
    public Person getPerson() {
        return getKey().getPerson();
    }

    @NotNull
    public YaGroup getGroup() {
        return getKey().getGroup();
    }

    @NotNull
    public PersonGroupMembershipType getMembershipType() {
        return getKey().getMembershipType();
    }

    public static final class Key implements Comparable<Key> {

        @NotNull
        private final Person person;
        @NotNull
        private final YaGroup group;
        @NotNull
        private final PersonGroupMembershipType membershipType;

        public Key(@NotNull final Person person, @NotNull final YaGroup group, @NotNull final PersonGroupMembershipType membershipType) {
            this.person = person;
            this.group = group;
            this.membershipType = membershipType;
        }

        @NotNull
        public Person getPerson() {
            return person;
        }

        @NotNull
        public YaGroup getGroup() {
            return group;
        }

        @NotNull
        public PersonGroupMembershipType getMembershipType() {
            return membershipType;
        }

        @Override
        public int compareTo(@NotNull final Key key) {
            return new CompareToBuilder()
                    .append(getPerson().getKey(), key.getPerson().getKey())
                    .append(getGroup().getKey(), key.getGroup().getKey())
                    .append(getMembershipType(), key.getMembershipType())
                    .build();
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final Key key = (Key) o;
            return Objects.equals(person, key.person) &&
                    Objects.equals(group, key.group) &&
                    membershipType == key.membershipType;
        }

        @Override
        public int hashCode() {
            return Objects.hash(person, group, membershipType);
        }

        @Override
        public String toString() {
            return "Key{" +
                    "person=" + person +
                    ", group=" + group +
                    ", membershipType=" + membershipType +
                    '}';
        }

    }

}
