package ru.yandex.qe.dispenser.domain;

import java.util.List;
import java.util.Set;

import org.jetbrains.annotations.NotNull;

public interface ProjectFieldsContext {

    @NotNull
    Set<String> getAllMembersOfProject(final Project project);

    @NotNull
    ProjectFieldsContext forkSingle();

    /**
     * Returns active campaign if present and initialized. Throws IllegalStateException if uninitialized.
     *
     * @return Active campaign if present and initialized.
     */
    @NotNull
    List<Campaign> getActiveCampaigns();

}
