package ru.yandex.qe.dispenser.domain;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.domain.index.LongIndexBase;

@ParametersAreNonnullByDefault
public class ProjectRole extends LongIndexBase {
    private final String key;
    private final AbcRoleSyncType abcRoleSyncType;
    @Nullable
    private final Long abcRoleId;

    public ProjectRole(final String key, final AbcRoleSyncType abcRoleSyncType, @Nullable final Long abcRoleId) {
        this.key = key;
        this.abcRoleSyncType = abcRoleSyncType;
        this.abcRoleId = abcRoleId;
    }

    public AbcRoleSyncType getAbcRoleSyncType() {
        return abcRoleSyncType;
    }

    public String getKey() {
        return key;
    }

    @Nullable
    public Long getAbcRoleId() {
        return abcRoleId;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ProjectRole that = (ProjectRole) o;
        return getId() == that.getId();
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

    @Override
    public String toString() {
        return "ProjectRole{" +
                "key='" + key + '\'' +
                ", id=" + getId() +
                ", abcRoleSyncType=" + abcRoleSyncType +
                ", abcRoleId=" + abcRoleId +
                '}';
    }

    public enum AbcRoleSyncType {
        MEMBER,
        RESPONSIBLE,
        ROLE,
        NONE
    }
}
