package ru.yandex.qe.dispenser.domain;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiMetaValueSet;
import ru.yandex.qe.dispenser.api.v1.DiProjectServiceMeta;

public final class ProjectServiceMeta {
    @NotNull
    private final Project project;
    @NotNull
    private final Service service;
    @NotNull
    private final DiMetaValueSet metaValues;

    public ProjectServiceMeta(@NotNull final Project project,
                              @NotNull final Service service,
                              @NotNull final DiMetaValueSet metaValues) {
        this.project = project;
        this.service = service;
        this.metaValues = metaValues;
    }

    @NotNull
    public static ProjectServiceMeta emtpy(@NotNull final Project project, @NotNull final Service service) {
        return new ProjectServiceMeta(project, service, DiMetaValueSet.EMPTY);
    }

    @NotNull
    public Project getProject() {
        return project;
    }

    @NotNull
    public Service getService() {
        return service;
    }

    @NotNull
    public DiMetaValueSet getMetaValues() {
        return metaValues;
    }

    @Override
    public boolean equals(@Nullable final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ProjectServiceMeta other = (ProjectServiceMeta) o;
        return project.equals(other.project) && service.equals(other.service);
    }

    @Override
    public int hashCode() {
        return 31 * project.hashCode() + service.hashCode();
    }

    @NotNull
    public DiProjectServiceMeta toView() {
        return DiProjectServiceMeta.builder()
                .ofProject(project.toView())
                .inService(service.toView())
                .withMeta(metaValues)
                .build();
    }
}
