package ru.yandex.qe.dispenser.domain;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.qe.dispenser.domain.index.LongIndexBase;

public class ProviderGroup extends LongIndexBase {
    private final String name;
    private final String description;
    private final long campaignId;
    private final ProviderGroupSettings settings;
    private final int priority;

    public ProviderGroup(final String name,
                         final String description,
                         final long campaignId,
                         final int priority,
                         final ProviderGroupSettings settings) {
        this.name = name;
        this.description = description;
        this.campaignId = campaignId;
        this.priority = priority;
        this.settings = settings;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public long getCampaignId() {
        return campaignId;
    }

    public ProviderGroupSettings getSettings() {
        return settings;
    }

    public int getPriority() {
        return priority;
    }

    public static class ProviderGroupSettings {
        private final List<Long> serviceIds;
        private final List<ResourceGroup> resourceGroups;

        @JsonCreator
        public ProviderGroupSettings(@JsonProperty("serviceIds") final List<Long> serviceIds,
                                     @JsonProperty("resourceGroups") final List<ResourceGroup> resourceGroups) {
            this.serviceIds = serviceIds;
            this.resourceGroups = resourceGroups;
        }

        public List<Long> getServiceIds() {
            return serviceIds;
        }

        public List<ResourceGroup> getResourceGroups() {
            return resourceGroups;
        }
    }

    public static class ResourceGroup {
        private final String name;
        private final List<Long> resourceIds;

        @JsonCreator
        public ResourceGroup(@JsonProperty("name") final String name,
                             @JsonProperty("resourceIds") final List<Long> resourceIds) {
            this.name = name;
            this.resourceIds = resourceIds;
        }

        public String getName() {
            return name;
        }

        public List<Long> getResourceIds() {
            return resourceIds;
        }
    }
}
