package ru.yandex.qe.dispenser.domain;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ProviderGroupReport {
    private final long providerGroupId;
    private final String providerGroupName;
    private final String providerGroupDescription;
    private final int providerGroupPriority;
    private final Report report;

    public ProviderGroupReport(final long providerGroupId,
                               final String providerGroupName,
                               final String providerGroupDescription,
                               final int providerGroupPriority,
                               final Report report) {
        this.providerGroupId = providerGroupId;
        this.providerGroupName = providerGroupName;
        this.providerGroupDescription = providerGroupDescription;
        this.providerGroupPriority = providerGroupPriority;
        this.report = report;
    }

    public long getProviderGroupId() {
        return providerGroupId;
    }


    public String getProviderGroupName() {
        return providerGroupName;
    }

    public String getProviderGroupDescription() {
        return providerGroupDescription;
    }

    public int getProviderGroupPriority() {
        return providerGroupPriority;
    }

    public Report getReport() {
        return report;
    }

    public static class Report {
        private final List<Location> locations;

        @JsonCreator
        public Report(@JsonProperty("locations") final List<Location> locations) {
            this.locations = locations;
        }

        public List<Location> getLocations() {
            return locations;
        }
    }

    public static class Location {
        private final String name;
        private final List<LocationBigOrder> bigOrders;

        @JsonCreator
        public Location(@JsonProperty("name") final String name,
                        @JsonProperty("bigOrders") final List<LocationBigOrder> bigOrders) {
            this.name = name;
            this.bigOrders = bigOrders;
        }

        public String getName() {
            return name;
        }

        public List<LocationBigOrder> getBigOrders() {
            return bigOrders;
        }
    }

    public static class LocationBigOrder {
        private final long bigOrderId;
        private final ServerCount serverCount;
        private final List<ResourceServers> resourceServers;

        @JsonCreator
        public LocationBigOrder(@JsonProperty("id") final long bigOrderId,
                                @JsonProperty("servers") final ServerCount serverCount,
                                @JsonProperty("resources") final List<ResourceServers> resourceServers) {
            this.bigOrderId = bigOrderId;
            this.serverCount = serverCount;
            this.resourceServers = resourceServers;
        }

        @JsonProperty("id")
        public long getBigOrderId() {
            return bigOrderId;
        }

        @JsonProperty("servers")
        public ServerCount getServerCount() {
            return serverCount;
        }

        @JsonProperty("resources")
        public List<ResourceServers> getResourceServers() {
            return resourceServers;
        }
    }

    public static class ResourceServers {
        private final String resourceKey;
        private final boolean isDominant;
        private final ServerCount serverCount;

        @JsonCreator
        public ResourceServers(@JsonProperty("resourceKey") final String resourceKey,
                               @JsonProperty("dominant") final boolean isDominant,
                               @JsonProperty("servers") final ServerCount serverCount) {
            this.resourceKey = resourceKey;
            this.isDominant = isDominant;
            this.serverCount = serverCount;
        }

        public String getResourceKey() {
            return resourceKey;
        }

        public boolean isDominant() {
            return isDominant;
        }

        @JsonProperty("servers")
        public ServerCount getServerCount() {
            return serverCount;
        }
    }

    public static class ServerCount {
        private final long total;
        private final long fromReserve;

        @JsonCreator
        public ServerCount(@JsonProperty("total") final long total,
                           @JsonProperty("fromReserve") final long fromReserve) {
            this.total = total;
            this.fromReserve = fromReserve;
        }

        public long getTotal() {
            return total;
        }

        public long getFromReserve() {
            return fromReserve;
        }
    }
}
