package ru.yandex.qe.dispenser.domain;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.core.type.TypeReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiQuotaRequestHistoryEvent;
import ru.yandex.qe.dispenser.api.v1.DiQuotaRequestHistoryEventType;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

public class QuotaChangeRequestHistoryEvent extends HistoryEvent {
    public static final TypeReference<Map<String, Object>> DATA_TYPE = new TypeReference<Map<String, Object>>() {
    };

    private final long quotaChangeRequestId;
    private final DiQuotaRequestHistoryEventType type;
    private final Map<String, Object> oldData;
    private final Map<String, Object> newData;

    public QuotaChangeRequestHistoryEvent(@Nullable final Long personId,
                                          @Nullable final Long tvmId,
                                          @NotNull final Instant updated,
                                          @Nullable final String comment,
                                          final long quotaChangeRequestId,
                                          @NotNull final DiQuotaRequestHistoryEventType type,
                                          @NotNull final Map<String, Object> oldData,
                                          @NotNull final Map<String, Object> newData) {
        super(personId, tvmId, updated, comment);
        this.quotaChangeRequestId = quotaChangeRequestId;
        this.type = type;
        this.oldData = oldData;
        this.newData = newData;
    }

    @NotNull
    public DiQuotaRequestHistoryEventType getType() {
        return type;
    }

    public long getQuotaChangeRequestId() {
        return quotaChangeRequestId;
    }

    @NotNull
    public Map<String, Object> getOldData() {
        return oldData;
    }

    @NotNull
    public Map<String, Object> getNewData() {
        return newData;
    }

    public DiQuotaRequestHistoryEvent toView() {
        final Long personId = getPersonId();
        String login = null;
        if (personId != null) {
            final Person person = Hierarchy.get().getPersonReader().read(personId);
            login = person.getLogin();
        }
        return DiQuotaRequestHistoryEvent.builder()
                .id(getId())
                .person(login)
                .updated(getUpdated())
                .tvmId(getTvmId())
                .comment(getComment())
                .requestId(quotaChangeRequestId)
                .type(type)
                .oldData(oldData)
                .newData(newData)
                .build();

    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        final QuotaChangeRequestHistoryEvent event = (QuotaChangeRequestHistoryEvent) o;
        return quotaChangeRequestId == event.quotaChangeRequestId &&
                type == event.type &&
                Objects.equals(oldData, event.oldData) &&
                Objects.equals(newData, event.newData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), quotaChangeRequestId, type, oldData, newData);
    }
}
