package ru.yandex.qe.dispenser.domain;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiCheckCompareType;

@ParametersAreNonnullByDefault
public enum QuotaCompareType {
    GREATER(DiCheckCompareType.GREATER, ">") {
        @Override
        public boolean test(final Double d1, final Double d2) {
            return d1 > d2;
        }
    },
    LESS(DiCheckCompareType.LESS, "<") {
        @Override
        public boolean test(final Double d1, final Double d2) {
            return d1 < d2;
        }
    };

    private final DiCheckCompareType diType;
    private final String title;

    QuotaCompareType(final DiCheckCompareType diType, final String caption) {
        this.diType = diType;
        this.title = caption;
    }

    public boolean test(final Number n1, final Number n2) {
        return test(n1.doubleValue(), n2.doubleValue());
    }

    public abstract boolean test(Double d1, Double d2);

    @NotNull
    public static QuotaCompareType of(final DiCheckCompareType compareType) {
        for (final QuotaCompareType value : values()) {
            if (value.diType == compareType) {
                return value;
            }
        }
        throw new IllegalArgumentException("Invalid compare type");
    }

    public String getTitle() {
        return title;
    }
}
