package ru.yandex.qe.dispenser.domain;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiAmount;

@ParametersAreNonnullByDefault
public interface QuotaView extends Comparable<QuotaView> {
    @NotNull
    Quota.Key getKey();

    long getMax();

    long getOwnMax();

    long getEffectiveOwnMax();


    long getOwnActual();

    long getTotalActual();


    @Nullable
    Long getLastOverquotingTs();


    @NotNull
    QuotaSpec getSpec();

    @NotNull
    Set<Segment> getSegments();

    boolean isTotal();

    @NotNull
    Project getProject();

    @NotNull
    Resource getResource();


    @NotNull
    DiAmount getMaxAmount();

    @NotNull
    DiAmount getTotalActualAmount();
}
