package ru.yandex.qe.dispenser.domain;

import java.util.Objects;

public class ResourceMapping {
    private final Resource resource;
    private final String foreignResourceKey;
    private final String foreignServiceKey;

    public ResourceMapping(final Resource resource, final String foreignResourceKey, final String foreignServiceKey) {
        this.resource = resource;
        this.foreignResourceKey = foreignResourceKey;
        this.foreignServiceKey = foreignServiceKey;
    }

    public Resource getResource() {
        return resource;
    }

    public String getForeignResourceKey() {
        return foreignResourceKey;
    }

    public String getForeignServiceKey() {
        return foreignServiceKey;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ResourceMapping that = (ResourceMapping) o;
        return Objects.equals(resource, that.resource) &&
                Objects.equals(foreignResourceKey, that.foreignResourceKey) &&
                Objects.equals(foreignServiceKey, that.foreignServiceKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resource, foreignResourceKey, foreignServiceKey);
    }
}
