package ru.yandex.qe.dispenser.domain;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.index.LongIndexBase;

/**
 * Привязка {@link Segmentation сегментации} к {@link Resource ресурсу}.
 */
@ParametersAreNonnullByDefault
public class ResourceSegmentation extends LongIndexBase implements Comparable<ResourceSegmentation> {

    @NotNull
    private final Resource resource;
    @NotNull
    private final Segmentation segmentation;

    public ResourceSegmentation(final Builder builder) {
        resource = builder.resource;
        segmentation = builder.segmentation;
        if (builder.id != null) {
            setId(builder.id);
        }
    }

    @NotNull
    public Resource getResource() {
        return resource;
    }

    @NotNull
    public Segmentation getSegmentation() {
        return segmentation;
    }

    @Override
    public int compareTo(@NotNull final ResourceSegmentation resourceSegmentation) {
        return new CompareToBuilder()
                .append(getResource(), resourceSegmentation.getResource())
                .append(getSegmentation(), resourceSegmentation.getSegmentation())
                .build();
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ResourceSegmentation that = (ResourceSegmentation) o;
        return Objects.equals(resource, that.resource) &&
                Objects.equals(segmentation, that.segmentation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resource, segmentation);
    }

    public static final class Builder {
        @NotNull
        private final Resource resource;
        @NotNull
        private final Segmentation segmentation;
        private Long id;

        public Builder(final Resource resource, final Segmentation segmentation) {
            this.resource = resource;
            this.segmentation = segmentation;
        }

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        @NotNull
        public ResourceSegmentation build() {
            return new ResourceSegmentation(this);
        }
    }
}
