package ru.yandex.qe.dispenser.domain;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ResourceUnit {
    private final long resourceId;
    private final String defaultUnit;
    private final UnitsSettings unitsSettings;

    public ResourceUnit(final long resourceId, final String defaultUnit, final UnitsSettings unitsSettings) {
        this.resourceId = resourceId;
        this.defaultUnit = defaultUnit;
        this.unitsSettings = unitsSettings;
    }

    public long getResourceId() {
        return resourceId;
    }

    public String getDefaultUnit() {
        return defaultUnit;
    }

    public UnitsSettings getUnitsSettings() {
        return unitsSettings;
    }

    public static class UnitsSettings {
        private final Map<String, UnitProperties> propertiesByUnitKey;

        @JsonCreator
        public UnitsSettings(@JsonProperty("propertiesByUnitKey") final Map<String, UnitProperties> propertiesByUnitKey) {
            this.propertiesByUnitKey = propertiesByUnitKey;
        }

        public Map<String, UnitProperties> getPropertiesByUnitKey() {
            return propertiesByUnitKey;
        }
    }

    public static class UnitProperties {
        private final String name;
        private final String localizationKey;

        @JsonCreator
        public UnitProperties(@JsonProperty("name") final String name,
                              @JsonProperty("localizationKey") final String localizationKey) {
            this.name = name;
            this.localizationKey = localizationKey;
        }

        public String getName() {
            return name;
        }

        public String getLocalizationKey() {
            return localizationKey;
        }
    }
}
