package ru.yandex.qe.dispenser.domain;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

public class SingleProjectFieldsContext implements ProjectFieldsContext {

    @Nullable
    private final List<Campaign> activeCampaigns;

    public SingleProjectFieldsContext(@Nullable final List<Campaign> activeCampaigns) {
        this.activeCampaigns = activeCampaigns;
    }

    @NotNull
    @Override
    public Set<String> getAllMembersOfProject(final Project project) {
        return new HashSet<>(
                Hierarchy.get()
                        .getProjectReader()
                        .getAllMembers(project.getPathToRoot())
                        .values()
        );
    }

    @NotNull
    @Override
    public ProjectFieldsContext forkSingle() {
        return this;
    }

    @NotNull
    @Override
    public List<Campaign> getActiveCampaigns() {
        if (activeCampaigns == null) {
            throw new IllegalStateException("Active campaign was not loaded");
        }
        return activeCampaigns;
    }

}
