package ru.yandex.qe.dispenser.domain;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiYandexGroupType;
import ru.yandex.qe.dispenser.domain.index.NormalizedPrimaryKeyBase;

public final class YaGroup extends NormalizedPrimaryKeyBase<String> {
    @NotNull
    private final DiYandexGroupType type;
    private final long staffId;
    private final boolean deleted;

    public YaGroup(@NotNull final String url, @NotNull final DiYandexGroupType type, final long staffId, final boolean deleted) {
        super(url);
        this.type = type;
        this.staffId = staffId;
        this.deleted = deleted;
    }

    @NotNull
    public String getUrl() {
        return getKey();
    }

    @NotNull
    public DiYandexGroupType getType() {
        return type;
    }

    public long getStaffId() {
        return staffId;
    }

    public boolean isDeleted() {
        return deleted;
    }

    @NotNull
    @Override
    public String toString() {
        return getUrl();
    }

}
