package ru.yandex.qe.dispenser.domain.abc;

import javax.annotation.ParametersAreNullableByDefault;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import org.jetbrains.annotations.Nullable;

@Path("api/v4")
@Consumes({"application/json"})
@Produces({"application/json"})
@ParametersAreNullableByDefault
public interface AbcApi {

    int MAX_PAGE_SIZE = 1000;
    int DEFAULT_PAGE_SIZE = 20;

    @GET
    @Path("services/")
    Page<AbcService> getServices(@QueryParam("id__in") String ids,
                                 @QueryParam("id__gt") Integer smallestAcceptableServiceId,
                                 @QueryParam("cursor") String cursor,
                                 @QueryParam("fields") String fields,
                                 @QueryParam("page") Integer page,
                                 @QueryParam("page_size") Integer pageSize,
                                 @QueryParam("parent__with_descendants") Integer parentId,
                                 @QueryParam("state__in") String states);

    @GET
    @Path("services/responsibles/")
    Page<AbcServiceResponsible> getServiceResponsibles(@QueryParam("service__in") String serviceIds,
                                                       @QueryParam("fields") String fields,
                                                       @QueryParam("page") Integer page,
                                                       @QueryParam("page_size") Integer pageSize
    );

    @GET
    @Path("services/members/")
    Page<AbcServiceMember> getServiceMembers(@QueryParam("id__gt") Integer smallestAcceptableServiceId,
                                             @QueryParam("cursor") String cursor,
                                             @QueryParam("service__in") String serviceIds,
                                             @QueryParam("role__in") String roles,
                                             @QueryParam("role__scope__in") String roleScopes,
                                             @QueryParam("fields") String fields,
                                             @QueryParam("page") Integer page,
                                             @QueryParam("page_size") Integer pageSize);

    @GET
    @Path("roles/")
    Page<AbcRole> getRoles(@QueryParam("service__in") String serviceIds,
                           @QueryParam("id__in") String ids,
                           @QueryParam("fields") String fields,
                           @QueryParam("page") Integer page,
                           @QueryParam("page_size") Integer pageSize);

    @GET
    @Path("services/members/")
    Page<AbcServiceMember> getServiceMembersByUsers(@QueryParam("person__in") String logins,
                                                    @QueryParam("service__state__in") String states,
                                                    @QueryParam("role") Long role,
                                                    @QueryParam("fields") String fields,
                                                    @QueryParam("page") Integer page,
                                                    @QueryParam("page_size") Integer pageSize);

    @GET
    @Path("services/gradient/")
    Page<AbcServiceGradient> getServicesGradient(@Nullable @QueryParam("cursor") String cursor);
}
