package ru.yandex.qe.dispenser.domain.abc;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNullableByDefault
public class AbcService extends AbcServiceReference {

    @Nullable
    private final List<AbcServiceReference> ancestors;
    @Nullable
    private final AbcServiceReference parent;
    @Nullable
    private final String slug;
    @Nullable
    private final TranslatedString name;
    @Nullable
    private final TranslatedString description;
    @Nullable
    private final AbcServiceState state;

    public AbcService(@JsonProperty("id") final Integer id,
                      @JsonProperty("ancestors") final List<AbcServiceReference> ancestors,
                      @JsonProperty("parent") final AbcServiceReference parent,
                      @JsonProperty("slug") final String slug,
                      @JsonProperty("name") final TranslatedString name,
                      @JsonProperty("description") final TranslatedString description,
                      @JsonProperty("state") final AbcServiceState state) {
        super(id);
        this.ancestors = ancestors;
        this.parent = parent;
        this.slug = slug;
        this.name = name;
        this.description = description;
        this.state = state;
    }

    @Nullable
    public List<AbcServiceReference> getAncestors() {
        return ancestors;
    }

    @Nullable
    public AbcServiceReference getParent() {
        return parent;
    }

    @Nullable
    public String getSlug() {
        return slug;
    }

    @Nullable
    public TranslatedString getName() {
        return name;
    }

    @Nullable
    public TranslatedString getDescription() {
        return description;
    }

    @Nullable
    public AbcServiceState getState() {
        return state;
    }
}
