package ru.yandex.qe.dispenser.domain.abc;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class AbcServiceGradient {
    public static final String TYPE_VALUE_STREAM = "vs";
    public static final String TYPE_UMBRELLA = "umb";

    private final long id;
    @Nullable
    private final String type;
    @Nullable
    private final Long valueStream;
    @Nullable
    private final Long umbrella;

    @JsonCreator
    public AbcServiceGradient(@JsonProperty("id") final long id,
                              @JsonProperty("type") @Nullable final String type,
                              @JsonProperty("valuestream") @Nullable final Long valueStream,
                              @JsonProperty("umbrella") @Nullable final Long umbrella) {
        this.id = id;
        this.type = type;
        this.valueStream = valueStream;
        this.umbrella = umbrella;
    }

    public long getId() {
        return id;
    }

    @Nullable
    public String getType() {
        return type;
    }

    @Nullable
    @JsonProperty("valuestream")
    public Long getValueStream() {
        return valueStream;
    }

    @Nullable
    public Long getUmbrella() {
        return umbrella;
    }
}
