package ru.yandex.qe.dispenser.domain.abc;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class AbcServiceMember extends AbcServicePersonHolder implements ObjectWithId {

    @Nullable
    private final AbcRole role;

    private final Integer id;

    public AbcServiceMember(@Nullable @JsonProperty("person") final AbcPerson person,
                            @Nullable @JsonProperty("service") final AbcServiceReference serviceReference,
                            @Nullable @JsonProperty("role") final AbcRole role,
                            @Nonnull @JsonProperty("id") final Integer id) {
        super(person, serviceReference);
        this.role = role;
        this.id = id;
    }

    @Nullable
    public AbcRole getRole() {
        return role;
    }

    @NotNull
    @Override
    public Integer getId() {
        return id;
    }
}
