package ru.yandex.qe.dispenser.domain.abc;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;

@ParametersAreNonnullByDefault
public enum AbcServiceState {
    DEVELOP("develop"),
    SUPPORTED("supported"),
    NEED_INFO("needinfo"),
    CLOSED("closed"),
    DELETED("deleted");

    @Nonnull
    private final String key;

    AbcServiceState(final String key) {
        this.key = key;
    }

    @Nonnull
    public String getKey() {
        return key;
    }

    @Nullable
    @JsonCreator
    public static AbcServiceState fromKey(final String key) {
        for (final AbcServiceState state : values()) {
            if (state.key.equals(key)) {
                return state;
            }
        }
        return null;
    }
}
