package ru.yandex.qe.dispenser.domain.abc;

import java.util.Iterator;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.response.DiCursorPage;

@ParametersAreNonnullByDefault
public class Page<T> implements DiCursorPage<T> {

    @Nonnull
    private final List<T> results;

    @Nullable
    private final String next;

    @Nullable
    private final String cursor;

    public Page(@JsonProperty("results") final List<T> results,
                @Nullable @JsonProperty("next") final String next) {
        this.results = results;
        this.next = next;
        this.cursor = extractCursor(next);
    }

    @Override
    public boolean hasNext() {
        return next != null;
    }

    @NotNull
    @Override
    public Iterator<T> iterator() {
        return results.iterator();
    }

    @Nullable
    @Override
    public String cursor() {
        return cursor;
    }
}
