package ru.yandex.qe.dispenser.domain.aspect;

import java.util.Arrays;
import java.util.List;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

@Aspect
public class SecondaryOperationAspect extends AspectBase {
    private static final Logger LOG = LoggerFactory.getLogger(SecondaryOperationAspect.class);
    private static final List<String> SECONDARY_PROFILES = Arrays.asList("development", "secondary");
    @Autowired
    private Environment environment;

    @Around("execution(public * *(..)) && @annotation(secondary)")
    public Object around(final @NotNull ProceedingJoinPoint jp, final @NotNull SecondaryOperation secondary) throws Throwable {
        final boolean isSecondary = Arrays.stream(environment.getActiveProfiles())
                .filter(SECONDARY_PROFILES::contains)
                .findAny()
                .isPresent();

        if (isSecondary) {
            return jp.proceed();
        } else {
            LOG.error("Can't execute operation {}! secondary node is required", jp.getSignature());
            throw new RuntimeException("secondary node required! " + jp.getSignature());
        }
    }
}
