package ru.yandex.qe.dispenser.domain.base_resources;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class BigOrderMappings {

    private final long bigOrderId;
    private final Map<Long, BaseResourceMapping> mappingsById;
    private final Map<Long, Set<Long>> mappingIdsByBaseResourceId;
    private final Map<ResourceAndSegmentsId, Set<Long>> mappingIdsByResourceId;

    public BigOrderMappings(long bigOrderId,
                            Map<Long, BaseResourceMapping> mappingsById,
                            Map<Long, Set<Long>> mappingIdsByBaseResourceId,
                            Map<ResourceAndSegmentsId, Set<Long>> mappingIdsByResourceId) {
        this.bigOrderId = bigOrderId;
        this.mappingsById = mappingsById;
        this.mappingIdsByBaseResourceId = mappingIdsByBaseResourceId;
        this.mappingIdsByResourceId = mappingIdsByResourceId;
    }

    public long getBigOrderId() {
        return bigOrderId;
    }

    public Map<Long, BaseResourceMapping> getMappingsById() {
        return mappingsById;
    }

    public Map<Long, Set<Long>> getMappingIdsByBaseResourceId() {
        return mappingIdsByBaseResourceId;
    }

    public Map<ResourceAndSegmentsId, Set<Long>> getMappingIdsByResourceId() {
        return mappingIdsByResourceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BigOrderMappings that = (BigOrderMappings) o;
        return bigOrderId == that.bigOrderId &&
                Objects.equals(mappingsById, that.mappingsById) &&
                Objects.equals(mappingIdsByBaseResourceId, that.mappingIdsByBaseResourceId) &&
                Objects.equals(mappingIdsByResourceId, that.mappingIdsByResourceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bigOrderId, mappingsById, mappingIdsByBaseResourceId, mappingIdsByResourceId);
    }

    @Override
    public String toString() {
        return "BigOrderMappings{" +
                "bigOrderId=" + bigOrderId +
                ", mappingsById=" + mappingsById +
                ", mappingIdsByBaseResourceId=" + mappingIdsByBaseResourceId +
                ", mappingIdsByResourceId=" + mappingIdsByResourceId +
                '}';
    }

}
