package ru.yandex.qe.dispenser.domain.base_resources;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class CampaignLimits {

    private final long campaignId;
    private final Map<Long, Set<BaseResourceLimit>> limitsByBaseResourceId;

    public CampaignLimits(long campaignId, Map<Long, Set<BaseResourceLimit>> limitsByBaseResourceId) {
        this.campaignId = campaignId;
        this.limitsByBaseResourceId = limitsByBaseResourceId;
    }

    public long getCampaignId() {
        return campaignId;
    }

    public Map<Long, Set<BaseResourceLimit>> getLimitsByBaseResourceId() {
        return limitsByBaseResourceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignLimits that = (CampaignLimits) o;
        return campaignId == that.campaignId &&
                Objects.equals(limitsByBaseResourceId, that.limitsByBaseResourceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId, limitsByBaseResourceId);
    }

    @Override
    public String toString() {
        return "CampaignLimits{" +
                "campaignId=" + campaignId +
                ", limitsByBaseResourceId=" + limitsByBaseResourceId +
                '}';
    }

}
