package ru.yandex.qe.dispenser.domain.base_resources;

import java.util.Map;
import java.util.Objects;

public final class CampaignMappings {

    private final long campaignId;
    private final Map<Long, BigOrderMappings> perBigOrderMappings;

    public CampaignMappings(long campaignId, Map<Long, BigOrderMappings> perBigOrderMappings) {
        this.campaignId = campaignId;
        this.perBigOrderMappings = perBigOrderMappings;
    }

    public long getCampaignId() {
        return campaignId;
    }

    public Map<Long, BigOrderMappings> getPerBigOrderMappings() {
        return perBigOrderMappings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignMappings that = (CampaignMappings) o;
        return campaignId == that.campaignId && Objects.equals(perBigOrderMappings, that.perBigOrderMappings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId, perBigOrderMappings);
    }

    @Override
    public String toString() {
        return "CampaignMappings{" +
                "campaignId=" + campaignId +
                ", perBigOrderMappings=" + perBigOrderMappings +
                '}';
    }

}
