package ru.yandex.qe.dispenser.domain.base_resources;

import java.util.Objects;
import java.util.Set;

public final class ResourceAndSegmentsId {

    private final long resourceId;
    private final Set<Long> segmentIds;

    public ResourceAndSegmentsId(long resourceId, Set<Long> segmentIds) {
        this.resourceId = resourceId;
        this.segmentIds = segmentIds;
    }

    public long getResourceId() {
        return resourceId;
    }

    public Set<Long> getSegmentIds() {
        return segmentIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceAndSegmentsId that = (ResourceAndSegmentsId) o;
        return resourceId == that.resourceId &&
                Objects.equals(segmentIds, that.segmentIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, segmentIds);
    }

    @Override
    public String toString() {
        return "ResourceAndSegmentsId{" +
                "resourceId=" + resourceId +
                ", segmentIds=" + segmentIds +
                '}';
    }

}
