package ru.yandex.qe.dispenser.domain.base_resources;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class WithBaseResourceChanges<T> {

    private final T value;
    private final Map<Long, Set<BaseResourceChange>> changesByQuotaRequest;

    public WithBaseResourceChanges(T value, Map<Long, Set<BaseResourceChange>> changesByQuotaRequest) {
        this.value = value;
        this.changesByQuotaRequest = changesByQuotaRequest;
    }

    public T getValue() {
        return value;
    }

    public Map<Long, Set<BaseResourceChange>> getChangesByQuotaRequest() {
        return changesByQuotaRequest;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WithBaseResourceChanges<?> that = (WithBaseResourceChanges<?>) o;
        return Objects.equals(value, that.value) &&
                Objects.equals(changesByQuotaRequest, that.changesByQuotaRequest);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value, changesByQuotaRequest);
    }

    @Override
    public String toString() {
        return "WithBaseResourceChanges{" +
                "value=" + value +
                ", changesByQuotaRequest=" + changesByQuotaRequest +
                '}';
    }

}
