package ru.yandex.qe.dispenser.domain.bot;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Abstract class for {@link ConfigurationComponent.Component} and {@link Configuration}
 *
 * @see ConfigurationComponent.Component
 * @see Configuration
 * @see BaseEntity
 */
@ParametersAreNonnullByDefault
public abstract class BaseConfigurationEntity extends BaseEntity {
    private final String fullName;
    private final boolean enabled;
    private final boolean recommended;
    @Nullable
    private final String description;

    public BaseConfigurationEntity(final String fullName, final Long typeId, final String typeCode, final String typeDisplay,
                                   final boolean enabled, final boolean recommended,
                                   @Nullable final String description) {
        super(typeId, typeCode, typeDisplay);

        this.fullName = fullName;
        this.enabled = enabled;
        this.recommended = recommended;
        this.description = description;
    }

    public String getFullName() {
        return fullName;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public boolean isRecommended() {
        return recommended;
    }

    @Nullable
    public String getDescription() {
        return description;
    }
}
